% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simu}
\alias{simu}
\title{A Simulated Data Set under Left Truncation but No Right Censoring}
\format{
A data frame with 500 subjects (rows) and 5 variables (columns).
\describe{
  \item{time}{the event time}
  \item{Q}{the left truncation time}
  \item{delta}{the event indicator}
  \item{Z1}{a continous covariate}
  \item{Z2}{a binary covariate}
}
}
\source{
Simulated
}
\usage{
data(simu)
}
\description{
A simulated data set under left truncation but no right censoring.
The left truncation time and the event time are dependent via the two covariates `Z1' and `Z2'.
Under the data generating mechanism,
the conditional distribution of the event time given covariates follows a Cox proportional hazards model in the full data, and
the conditional distribution of the left truncation time given covariates follows a Cox proportional hazards model on the reversed time scale in the full data.
The truncation rate is 29.5\%;
and the truth \eqn{P^*(T>3) = 0.5755753}.
}
\examples{
data(simu)
}
\keyword{datasets}
