% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanvar.R
\name{meanvar}
\alias{meanvar}
\title{Mean and variance for a truncated multivariate normal distribution.}
\usage{
meanvar(Obj)
}
\arguments{
\item{Obj}{An mtrunmnt object created by the \code{\link{mtrunmnt}}.}
}
\value{
A list with the mean and variance-covariance matrix.
}
\description{
\code{meanvar} is a S3 generic function of the class \code{\link{mtrunmnt}}. 
    Using the \code{\link{prodmnt}}, it compute the mean and 
    variance-covariance matrix for a truncated multivariate normal 
    distribution.
}
\examples{
###  A simple example ####

set.seed(123)
sigma2e <- 1
sigma2a <- 2
n <- 5
mu <- seq(-1,1, length.out = n)
y <- mu + rnorm(1, sd = sqrt(sigma2a)) + rnorm(n, sd = sqrt(sigma2e))
a  <- rep(-Inf, n)
b  <- rep(Inf, n)
a[y >= 0] <- 0
b[y <  0] <- 0
obj <- mtrunmnt(mu, lower = a, upper = b, Sigmae = sigma2e, D = sigma2a) 
meanvar(obj)

}
\seealso{
\code{\link{mtrunmnt}}, \code{\link[MomTrunc]{meanvarTMD}}, 
    \code{\link[tmvtnorm]{mtmvnorm}} and \code{\link{prodmnt}}.
}
