% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula.R
\name{dvinecopula}
\alias{dvinecopula}
\title{Constructor function for dvinecopula process}
\usage{
dvinecopula(family = "indep", pars = list(NULL), rotation = 0)
}
\arguments{
\item{family}{a vector of family names}

\item{pars}{a list containing the parameters of the copula at each lag}

\item{rotation}{a vector of rotations}
}
\value{
An object of class \linkS4class{dvinecopula}.
}
\description{
This function sets up a stationary d-vine process of finite order where the elements of
the (finite-length) copula sequence may be any copulas that can be implemented using
\code{\link[rvinecopulib]{bicop_dist}} in the \code{rvinecopulib} package.
}
\details{
Copulas may also be rotated through 90, 180 and 270 degrees.  If the
same \code{family} or same \code{rotation} is to be used at every lag, these arguments may be scalars.
The \code{pars} argument must be a list with the same length as the copula sequence.

If a t copula is included, the correlation parameter precedes the degrees of freedom in the parameter vector.
This copula should be referred to as "t" rather than "Student".
}
\examples{
dvinecopula(family = c("joe", "gauss", "t"), pars = list(3, .5, c(0.4, 4)), rotation = c(180, 0, 0))
}
