% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_seas_adj.R
\name{ts_fil_seas_adj}
\alias{ts_fil_seas_adj}
\title{Seasonal Adjustment}
\usage{
ts_fil_seas_adj(frequency = NULL)
}
\arguments{
\item{frequency}{Frequency of the time series. It is an optional parameter.
It can be configured when the frequency of the time series is known.}
}
\value{
A \code{ts_fil_seas_adj} object.
}
\description{
Remove the seasonal component from a time series while preserving
level and trend, using a state-space/BATS approach.
}
\examples{
# Seasonal adjustment using BATS at known frequency
# Load package and example data
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2 * tsd$y[9]  # inject an outlier (illustrative)

# Fit seasonal adjustment (set frequency if known) and transform
filter <- ts_fil_seas_adj(frequency = 26)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Plot original vs seasonally adjusted series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item R. J. Hyndman and G. Athanasopoulos (2021). Forecasting: Principles and
Practice (3rd ed). OTexts. (BATS/seasonal adjustment)
}
}
