% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/per_rob_Qn.r
\name{PerQn}
\alias{PerQn}
\title{Robust periodogram based on the Robust ACF}
\usage{
PerQn(x, window = "truncated", bandw.rob = 0.7)
}
\arguments{
\item{x}{univariate time series}

\item{window}{character string giving the type of the window. Allowed values are "truncated" (the default) or "\code{NULL}".}

\item{bandw.rob}{is a numeric value giving the truncation point.}
}
\value{
a numeric vector containing the values of the robust periodogram proposed by Molinares (2009).
}
\description{
Computes the robust pseudo-periodogram of Molinares et al (2009) based on the robust ACF by Ma and Genton (2000).
}
\examples{
PerQn(ldeaths)
}
\references{
Molinares, F. F. and Reisen, V. A., and Cribari-Neto, F. (2009) Robust estimation in long-memory processes under additive outliers. \emph{Journal of Statistical Planning and Inference}, \bold{139}, 2511--2525.

Ma, Y. and Genton, M. G. (2000) Highly robust estimation of the autocovariance function. \emph{Journal of Time Series Analysis}, \bold{21}, 663--684.
}
\author{
Valderio Reisen and Higor Cotta
}
