% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_decompose.R
\name{robust_decompose}
\alias{robust_decompose}
\title{Robust time series seasonal decomposition}
\usage{
robust_decompose(
  x,
  S,
  wsize = max(2 * max(S), 25),
  use.trend = TRUE,
  K = 4,
  ICpen = "BIC",
  extreg = NULL,
  use.autoregressive = NULL
)
}
\arguments{
\item{x}{a time series.}

\item{S}{a number or vector describing the seasonalities (S_1, ..., S_K) in
the data, e.g. c(24, 168) if the data consists of 24 observations per day
and there is a weekly seasonality in the data.}

\item{wsize}{is filter/rolling med size}

\item{use.trend}{if TRUE, uses standard decomposition. If FALSE, uses no
trend component.}

\item{K}{a sigma (standard deviation) bound. The observations that exceed
sigma*K become reduced weight in the regression.}

\item{ICpen}{is the information criterion penalty, e.g. string "BIC", "HQC"
or "AIC", or a fixed number.}

\item{extreg}{a vector, matrix or data frame of data containing external
regressors; each column is a variable.}

\item{use.autoregressive}{if TRUE, removes the autoregression from the
series. If NULL, it is derived data based.}
}
\value{
A list which contains a vector of fitted values, a vector of weights
given to the original time series, and a matrix of components of the
decomposition.\insertNoCite{*}{tsrobprep}
}
\description{
Decompose a time series into trend, level and potentially multiple seasonal
components including all interactions. The function allows for missings.
}
\examples{
\dontrun{
GBload.decomposed <- robust_decompose(GBload[,-1], S = c(48,7*48))
head(GBload.decomposed$components)
}
}
\references{
\insertAllCited{}
}
