% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations_xl.R
\name{expect_equal_xl}
\alias{expect_equal_xl}
\alias{expect_identical_xl}
\alias{expect_equivalent_xl}
\title{Extensions of equality tests for tinytest}
\usage{
expect_equal_xl(
  current,
  target,
  useDiffObj = TRUE,
  tol = sqrt(.Machine$double.eps),
  info = NA_character_,
  mode = getOption("diffobj.mode", "unified"),
  format = getOption("diffobj.format", "ansi256"),
  ...
)

expect_identical_xl(
  current,
  target,
  useDiffObj = TRUE,
  info = NA_character_,
  mode = getOption("diffobj.mode", "unified"),
  format = getOption("diffobj.format", "ansi256"),
  ...
)

expect_equivalent_xl(
  current,
  target,
  useDiffObj = TRUE,
  tol = sqrt(.Machine$double.eps),
  info = NA_character_,
  mode = getOption("diffobj.mode", "unified"),
  format = getOption("diffobj.format", "ansi256"),
  ...
)
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{target}{\code{[R object or expression]} Expected outcome}

\item{useDiffObj}{\code{[logical]} Whether you should use \code{diffPrint} for the diff field 
in the resulting tinytest object}

\item{tol}{\code{[numeric]} Test equality to machine rounding. Passed
to \code{\link[base]{all.equal} (tolerance)}}

\item{info}{An additional attribute to pass around with the tinytest object}

\item{mode}{\code{[character]} Comparison mode passed to \code{diffPrint},
defaults to using the \dQuote{diffobj.mode} global option value with
\dQuote{unified} as fallback if no such option is set}

\item{format}{\code{[character]} Comparison mode passed to \code{diffPrint},
defaults to to using the \dQuote{diffobj.format} global option value with
\dQuote{ansi256} as fallback if no such option is set}

\item{...}{Passed to \code{all.equal} and returned as a test attributes}
}
\value{
A \code{\link[tinytest]{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the
test that was run
}
\description{
Building on the tinytest functions for testing equality with optional enhanced object 
diffing and additional test feedback through addtional attributes.
}
\details{
While tinytest does now support the passing of additional information with the info
field in its tests, they are not yet supported in the \code{as.data.frame.tinytests}
method.
}
\examples{
library(tinytest)
using(ttdo)
expect_equal_xl(1 + 1, 2, score = 3) # TRUE
expect_equal_xl(1 - 1, 2, name = "check 1-1==2", score = 1, totalpts = 2) # FALSE
}
