% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{expect_visual_equal_with_diff}
\alias{expect_visual_equal_with_diff}
\title{Test for plot equality with 'diff' generation}
\usage{
expect_visual_equal_with_diff(proposed, reference, difference, ...)
}
\arguments{
\item{proposed}{Character value with filename of proposed solution, should be png}

\item{reference}{Character value with filename of reference plot, should be png}

\item{difference}{Character value with filename for difference plot (if plots differ)}

\item{...}{Passes on to \code{tinysnapshot::expect_equivalent_images()}}
}
\value{
The \code{tinytest} result object where the \code{diff} attribute contains the
suitable value that can be passed onto the JSON output, i.e. a character string beginning
with \code{"date:image/png;base64,"} followed with the base64 encoded file. The class
attribute is set to \code{c("ttvd", "tinytest")} to signal that it is a 'visual diff' result.
}
\description{
This \code{tinytest}-compatible expectation compares two plots supplied as files (which
should be png files) and returns \emph{visual} difference in a plot file (for which the
designated file has to be supplied).

The labels \dQuote{old} (for the reference plot compared against), \dQuote{new} (for
the candidate plot, and \dQuote{diff} can be set as value to the global option
\code{tinysnapshot_plot_diff_style}. For example settings \code{c("old", "new", "diff")}
shows all three, setting \code{c("new", "diff")} just these two. The default is to only show
the \sQuote{diff} plot.
}
