% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_captions.R
\name{get_captions}
\alias{get_captions}
\title{Get Particular Caption Track}
\usage{
get_captions(id = NULL, lang = "en", format = "sbv", as_raw = TRUE, ...)
}
\arguments{
\item{id}{String. Required. id of the caption track that is being retrieved}

\item{lang}{Optional. Default is \code{en}.}

\item{format}{Optional. Default is \code{sbv}.}

\item{as_raw}{If \code{FALSE} the captions be converted to a character
string versus a raw vector}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
String.
}
\description{
For getting captions from the v3 API, you must specify the id resource.
Check \code{\link{list_caption_tracks}} for more information.
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_captions(id = "y3ElXcEME3lSISz6izkWVT5GvxjPu8pA")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/captions/download}
}
