% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_playlist_item_videoids.R
\name{get_playlist_item_videoids}
\alias{get_playlist_item_videoids}
\title{Get Playlist Item Video IDs}
\usage{
get_playlist_item_videoids(
  filter = NULL,
  part = "contentDetails",
  max_results = 50,
  video_id = NULL,
  page_token = NULL,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{filter}{string; Required.
named vector of length 1
potential names of the entry in the vector:
\code{item_id}: comma-separated list of one or more unique playlist item IDs.
\code{playlist_id}: YouTube playlist ID.}

\item{part}{Required. Comma separated string including one or more of the
following: \code{contentDetails, id, snippet, status}. Default:
\code{contentDetails}.}

\item{max_results}{Maximum number of items that should be returned.
Integer. Optional. Default is 50. Values over 50 trigger multiple requests and
may increase API quota usage.}

\item{video_id}{Optional. request should return only the playlist
items that contain the specified video.}

\item{page_token}{specific page in the result set that should be
returned, optional}

\item{simplify}{returns a data.frame rather than a list.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
playlist items
}
\description{
Get Playlist Item Video IDs
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_playlist_items(filter =
                       c(playlist_id = "YourPlaylistID"))
get_playlist_items(filter =
                       c(playlist_id = "YourPlaylistID"),
                       max_results = 51)
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/playlists/list}
}
