% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvYearAnnuityCompSemiAnnually.R
\name{fvYearlyAnnuityCompSemiAnnually}
\alias{fvYearlyAnnuityCompSemiAnnually}
\title{Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Semi-Annually.}
\usage{
fvYearlyAnnuityCompSemiAnnually(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}.
}
\description{
Calculates Future Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Semi-Annually.
}
\details{
As \insertCite{brook;textual}{tvmComp} mentions that Future Value calculations value cash flow at a single point in time in the future.
The method \code{fvYearlyAnnuityCompSemiAnnually()} is developed to calculate Future Value of Yearly-Paid Ordinary Annuity or Annuity Due that is Compounded Semi-Annually. The method gives Future Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments)
}
\examples{
fvYearlyAnnuityCompSemiAnnually(0.11,4,-300,0)
fvYearlyAnnuityCompSemiAnnually(0.11,4,-300,1)
fvYearlyAnnuityCompSemiAnnually(0.11,4,300,0)
fvYearlyAnnuityCompSemiAnnually(0.11,4,300,1)
}
\references{
\insertRef{brook}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
