% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvAnytypPerpetuity.R
\name{pvAnytypePerpetuity}
\alias{pvAnytypePerpetuity}
\title{Computing Present Value of an Ordinary Perpetuity or Perpetuity Due.}
\usage{
pvAnytypePerpetuity(r, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to three arguments \code{r} , \code{pmt} and \code{bgn}.
}
\description{
Computing Present Value of an Ordinary Perpetuity or Perpetuity Due.
}
\details{
According to \insertCite{humm;textual}{tvmComp}, a Perpetuity is an annuity for which the payments continue forever. When the size of the periodic payment from a fund is equal to the periodic interest earned by the fund, such as an endowment fund to a university or a continuous benefit from a capital investment, a Perpetuity gets resulted.
The method \code{pvAnytypePerpetuity()} is developed to compute Present Value(PV) of an Ordinary Perpetuity or Perpetuity Due.The method gives Present Value when values are passed to its three arguments. Here \code{r} is annual rate, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments)
}
\examples{
pvAnytypePerpetuity( 0.08, 4.5, 1)
pvAnytypePerpetuity( 0.08, 4.5, 0)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
