% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{calculate.utilization}
\alias{calculate.utilization}
\title{calculate.utilization}
\usage{
calculate.utilization(
  dat,
  outcome.names,
  begin,
  end,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  type = "rate",
  full.followup = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{dat}{A data frame structured as a panel data set.}

\item{outcome.names}{A character vector of variable names from dat representing binary
conditions (1/0, TRUE/FALSE) whose utilization is to be calculated.}

\item{begin}{The numeric starting time for the interval of interest.}

\item{end}{The numeric ending time for the interval of interest.}

\item{id.name}{The character name of the identifying variable within dat,
used to track subjects across multiple rows.}

\item{t1.name}{The character name of the time-tracking variable within dat
representing the start (left endpoint) of each observation interval.}

\item{t2.name}{The character name of the time-tracking variable within dat
representing the end (right endpoint) of each observation interval.}

\item{type}{A character string specifying the type of utilization to calculate:
"rate" for proportion of time, or "total"/"count" for the count of days. Defaults to "rate".}

\item{full.followup}{A logical value indicating whether to include all subjects
or only those with fully observed records in the specified interval. Defaults to FALSE.}

\item{na.rm}{A logical value indicating whether missing values should be excluded
from the calculation. Defaults to TRUE.}
}
\value{
Returns a data.table object that contains the calculated utilization
information for each subject specified by id.name. If type is "rate", it returns
the proportion of the interval [begin, end) during which the conditions specified
in outcome.names are met. If type is "total" or "count", it returns the total count
of days within the interval where the conditions are met. The result is grouped by
the id.name variable, ensuring each subject's data is aggregated separately.
}
\description{
Calculates the amount or proportion of time that a condition
(e.g., use of a medication) is met for each subject over a specified observation period.
}
