% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{cross.sectional.data}
\alias{cross.sectional.data}
\title{cross.sectional.data}
\usage{
cross.sectional.data(
  dat,
  time.point = 0,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  outcome.names = NULL,
  relative.followup = FALSE
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{time.point}{The numeric time at which to create the cross-sectional data.
This represents the point in time for which the data snapshot is taken. Subjects are
included in the snapshot if they have data recorded at this time point.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows of data.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}

\item{outcome.names}{A character vector of outcome variable names from dat, which
should be binary. The function calculates the time since the time.point that each
outcome first becomes 1 for each unique id.}

\item{relative.followup}{A logical indicating whether to return the outcomes in
absolute time (FALSE) or relative to the time.point (TRUE). Outcomes before the
time.point are disregarded when TRUE.}
}
\value{
Returns a data frame or data table, depending on the input, containing the
cross-sectional data extracted at the specified time.point. The dataset includes each
subject observed at the time.point, with the relevant outcomes and other variables
adjusted based on the specified parameters. If outcome.names are provided, it includes
the calculated times from the specified time.point to the first occurrence of the
outcomes for each subject. If relative.followup is TRUE, these times are relative to
the time.point; otherwise, they are in absolute terms. The structure of the returned
data is ideal for analyses focusing on the status of subjects at a specific moment
in the study period.
}
\description{
Creates a cross-sectional cohort from a panel data structure at a specified
time point. It focuses on outcome variables, indicating the time elapsed after the
specified point until an event occurred.
}
