% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{unusual.duration}
\alias{unusual.duration}
\title{unusual.duration}
\usage{
unusual.duration(dat, outcome.name, max.length, t1.name = "t1", t2.name = "t2")
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{outcome.name}{The character name of a binary variable within dat, representing the
event of interest. Only records where this event is true (1) are considered for analysis.}

\item{max.length}{A numeric value specifying the maximum allowed duration for the event.
Records where the event duration exceeds this threshold are identified as unusual.}

\item{t1.name}{The character name of the time variable within dat representing the start
(left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the end
(right endpoint) of observation intervals.}
}
\value{
Returns a subset of the original data frame containing only those records where
the specified event occurs for a duration longer than the max.length parameter. Each row
in this subset corresponds to an event considered unusually long, allowing for easy
identification and further examination of these cases. This filtered dataset is instrumental
in quality control and ensuring the accuracy and reliability of longitudinal data analyses.
}
\description{
Identifies records within panel data where specified events occur for an unusually
long duration, exceeding a predefined maximum length. This is critical for detecting outliers
or anomalous data points in longitudinal studies.
}
