% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_icers.R
\name{calculate_icers}
\alias{calculate_icers}
\title{Calculate Incremental Cost-Effectiveness Ratios (ICERs)}
\usage{
calculate_icers(payoffs_summary, col_names = c("cost", "utility"))
}
\arguments{
\item{payoffs_summary}{A matrix or data frame containing the summary statistics of the payoffs. It must have columns for cost and utility.}

\item{col_names}{A character vector specifying the names of the columns for cost and utility. Default is c("cost", "utility").}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{decision}: The name of the strategy.
\item \code{cost}: The cost of the strategy.
\item \code{utility}: The effect (utility) of the strategy.
\item \code{inc_cost}: The incremental cost compared to the next less effective strategy.
\item \code{inc_utility}: The incremental effect compared to the next less effective strategy.
\item \code{ICER}: The Incremental Cost-Effectiveness Ratio.
\item \code{status}: The dominance status of the strategy (ND = non-dominated, D = dominated, ED = extendedly dominated).
}
}
\description{
This function calculates the Incremental Cost-Effectiveness Ratios (ICERs) for a set of strategies based on their costs and effects.
}
\examples{
payoffs_summary <- matrix(c(100, 200, 0.5, 0.7), ncol = 2, 
                          dimnames = list(c("Strategy A", "Strategy B"), 
                                          c("cost", "utility")))
calculate_icers(payoffs_summary)
}
