% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twinning.R
\name{energy}
\alias{energy}
\title{Energy distance computation}
\usage{
energy(data, points)
}
\arguments{
\item{data}{The dataset including both the predictors and response(s). A numeric matrix is expected. If the dataset has factor columns, the user is expected to convert them to numeric using a coding method.}

\item{points}{The set of points for which the energy distance with respect to \code{data} is to be computed. A numeric matrix is expected.}
}
\value{
Energy distance.
}
\description{
\code{energy()} computes the energy distance (Székely and Rizzo, 2013)  between a given dataset and a set of points in same dimensions.
}
\details{
Smaller the energy distance, the more statistically similar the set of points is to the given dataset. The minimizer of energy distance is known as support points (Mak and Joseph, 2018), which is the basis of the twinning method. Computing energy distance between \code{data} and \code{points} involves Euclidean distance calculations among the rows of \code{data}, among the rows of \code{points}, and between the rows of \code{data} and \code{points}. Since, \code{data} serves as the reference, the distance calculations among the rows of \code{data} are ignored for efficiency. Before computing the energy distance, the columns of \code{data} are scaled to zero mean and unit standard deviation. The mean and standard deviation of the columns of \code{data} are used to scale the respective columns in \code{points}.
}
\examples{
## Energy distance between a dataset and a random sample
X = rnorm(n=100, mean=0, sd=1)
Y = rnorm(n=100, mean=X^2, sd=1)
data = cbind(X, Y)
energy(data, data[sample(100, 20), ])

}
\references{
Vakayil, A., & Joseph, V. R. (2022). Data Twinning. Statistical Analysis and Data Mining: The ASA Data Science Journal, to appear. arXiv preprint arXiv:2110.02927.

Székely, G. J., & Rizzo, M. L. (2013). Energy statistics: A class of statistics based on distances. Journal of statistical planning and inference, 143(8), 1249-1272.

Mak, S. & Joseph, V. R. (2018). Support Points. Annals of Statistics, 46, 2562-2592.
}
