% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_twn.R
\name{is_twn}
\alias{is_twn}
\alias{is_valid_twn}
\title{Controleer of taxonnamen in de TWN voorkomen}
\usage{
is_twn(taxa)

is_valid_twn(taxa)
}
\arguments{
\item{taxa}{Een vector met taxonnamen.}
}
\value{
Logical
}
\description{
Deze functies kunnen gebruikt worden om te checken of taxa in de TWN-lijst voorkomen
en of het taxa zijn met een valide status (10, 20 of 80).
}
\details{
Deze functies checken of taxa voorkomen in de TWN-lijst en of de status
valide is
\itemize{
\item \code{is_twn}: Geeft aan of een taxonnaam in de TWN-lijst voorkomt.
\item \code{is_valid_twn}: Geeft aan of een taxonnaam in de TWN-lijst voorkomt met status
10, 20 of 80.
}
}
\examples{

taxa <- c("Bufo calamita", "Bufo", "Buf", NA)
invalid <- "Abies veitchii 1861"
is_twn(taxa)
is_valid_twn(taxa)

is_twn(invalid)
is_valid_twn(invalid)

}
