% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.txshift}
\alias{print.txshift}
\title{Print Method for Counterfactual Mean of Stochastic Shift Intervention}
\usage{
\method{print}{txshift}(x, ..., ci_level = 0.95)
}
\arguments{
\item{x}{An object of class \code{txshift}.}

\item{...}{Other options (not currently used).}

\item{ci_level}{A \code{numeric} indicating the level of the confidence
interval to be computed.}
}
\value{
None. Called for the side effect of printing an informative summary
 of slots of objects of class \code{txshift}.
}
\description{
Print Method for Counterfactual Mean of Stochastic Shift Intervention
}
\details{
The \code{print} method for objects of class \code{txshift}.
}
\examples{
if (require("sl3")) {
  set.seed(429153)
  n_obs <- 100
  W <- replicate(2, rbinom(n_obs, 1, 0.5))
  A <- rnorm(n_obs, mean = 2 * W, sd = 1)
  Y <- rbinom(n_obs, 1, plogis(A + W + rnorm(n_obs, mean = 0, sd = 1)))
  txout <- txshift(
    W = W, A = A, Y = Y, delta = 0.5,
    estimator = "tmle",
    g_exp_fit_args = list(
      fit_type = "sl",
      sl_learners_density = Lrnr_density_hse$new(Lrnr_glm$new())
    ),
    Q_fit_args = list(
      fit_type = "glm",
      glm_formula = "Y ~ ."
    )
  )
  print(txout)
}
}
