% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracer-inject.R
\name{inject_tracer}
\alias{inject_tracer}
\title{Inject parameter tracer into one function}
\usage{
inject_tracer(f, trace_lists = FALSE)
}
\arguments{
\item{f}{A function (that is, an object of class "function", and not a
character string).}

\item{trace_lists}{If \code{TRUE}, trace into any nested list parameters
(including \code{data.frame}-type objects), and return type information on each
list component. The parameter names for these list-components are then
specified in "dollar-notation", for example 'Orange$age'.}
}
\value{
Nothing (will error on fail).
}
\description{
Inject parameter tracer into one function
}
\note{
The tracer is defined in the internal \code{typetracer_header()} function.
This uses an \code{options} variable defined on package load for the current
\code{tempdir}, defining a single location where all traced values are dumped.
This is done via \code{options} to allow both multi-threaded function calls and
calls via \pkg{callr} to be traced.
}
\examples{
f <- function (x, y, z, ...) {
    x * x + y * y
}
inject_tracer (f)
val <- f (1:2, 3:4 + 0., a = "blah")
x <- load_traces ()

# Traces should always be "uninjected":
uninject_tracer (f)
# Traces may also be removed:
clear_traces ()
}
