
<!-- README.md is generated from README.Rmd. Please edit that file -->

# typr <img src='man/figures/logo.png' align='right' height='100' alt='' />

<!-- badges: start -->

[![R-CMD-check](https://github.com/christopherkenny/typr/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/christopherkenny/typr/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

The goal of `typr` is to render Typst documents from R. By default, it
will try to use the Typst CLI. If the Typst CLI is not installed, it
will try to use Quarto, which bundles Typst.

## Installation

You can install the development version of `typr` from
[GitHub](https://github.com/christopherkenny/typr) with:

``` r
# install.packages('pak')
pak::pak('christopherkenny/typr')
```

## Example

The following example shows how to use `typr` to render a Typst
document. It can take a path to a file or lines to use. Below, I pass
lines to compile:

``` r
library(typr)

doc <- c(
  '#set page(height: auto, width: auto)',
  '= Example Doc',
  'Some text'
)

typr_compile(doc, output_format = 'png')
#> C:/Users/chris/AppData/Local/Temp/Rtmpeow7sK/filea881b5c2983.png
```

<figure>
<img src="man/figures/example.png"
alt="Example image generated by the above code" />
<figcaption aria-hidden="true">Example image generated by the above
code</figcaption>
</figure>
