% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/u5mr_cohort.R
\name{u5mr_cohort}
\alias{u5mr_cohort}
\title{Estimating under-five mortality using Maternal age cohort-derived methods}
\usage{
u5mr_cohort(
  data,
  women = "women",
  child_born = "child_born",
  child_dead = "child_dead",
  agegrp = "agegrp",
  iso3 = "KHM",
  svy_year = 2010
)
}
\arguments{
\item{data}{preprocessed data}

\item{women}{total number of women}

\item{child_born}{children ever born}

\item{child_dead}{children dead}

\item{agegrp}{age grouping or time since first birth}

\item{iso3}{the \code{iso3} code of the country from which the survey data come}

\item{svy_year}{end of the survey}
}
\value{
\code{data.frame}
\itemize{
\item \code{iso3} - total number of women
\item \code{svy_year} - total number of children ever born
\item \code{agegrp} - five-year age groups
\item \code{ref_time}  - time between survey year and interpolated year
\item \code{year}  - reference year
\item \code{q5} - under-five mortality
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{u5mr_cohort()} uses the maternal age cohort-derived methods (MAC) through summary
birth history information and maternal age (or time since first birth) to
calculate the under-five mortality estimates.
}
\details{
In this cohort-derived method, under-five mortality and reference time are estimated
through summary birth history information from the mothers and her age or time since
her first birth.

In case sample weights are available for the mothers, final variables
should be multiplied by these weights before summarizing.

\strong{Computational Procedure}

Two formulas were used to quantify MAC method:

\strong{\eqn{5q0} component}

logit(\out{5q0<sub>ijk</sub>}) = \eqn{\beta}\out{<sub>0i</sub>} + \out{U<sub>ij</sub>} +
\eqn{\beta}\out{<sub>1i</sub>} x logit(\out{CD<sub>ijk</sub>} /
\out{CEB<sub>ijk</sub>}) + \eqn{\beta}\out{<sub>2i</sub>} x \out{CEB<sub>ijk</sub>} +
\eqn{\beta}\out{<sub>3i</sub>} x PR1 + \eqn{\beta}\out{<sub>4i</sub>} x PR2 +
\eqn{\epsilon}\out{<sub>ijk</sub>}

where

i = 5-year maternal age group \eqn{\epsilon} (15-19, 20-24, ... , 45-49)
j = country
k = survey
\out{CD<sub>i</sub>} = total dead children from maternal age group \code{i}
\out{CEB<sub>i</sub>} = total children ever born from maternal age group \code{i}
PR1 = ratio of parity among maternal age group 15-19 and parity among maternal age
group 20-24
PR2 = ratio of parity among maternal age group 20-24 and parity among maternal age
group 25-29
\out{U<sub>ij</sub>} = country-specific random effects

All coefficients vary by maternal age group, as indicated by \code{i} and the random
effects also vary by country, as indicated by \code{j}.

\strong{Reference time component}

\out{reftime<sub>ijk</sub>} = \eqn{\beta}\out{<sub>0i</sub>} +
\eqn{\beta}\out{<sub>1i</sub>} x (\out{CD<sub>ijk</sub>} /
\out{CEB<sub>ijk</sub>}) +
\eqn{\beta}\out{<sub>2i</sub>} x \out{CEB<sub>ijk</sub>} +
\eqn{\beta}\out{<sub>3i</sub>} x PR1 + \eqn{\beta}\out{<sub>4i</sub>} x PR2 +
\eqn{\epsilon}\out{<sub>ijk</sub>}
}
\examples{

## Example using fake survey data from Cambodia
data(cambodia)
camb <- u5mr_cohort(cambodia, women = "women", child_born = "child_born",
child_dead = "child_dead", agegrp = "agegrp", iso3 = "KHM", svy_year = 1234)

with(camb,
     plot(year, q5 * 1000, type = "b", pch = 19,
          col = "black", xlab = "Year", ylab = "U5MR per 1000 live births",
          main = paste0("Under-five mortality, q(5) in Bangladesh, estimated\n",
                       "using the maternal age cohort-derived method")))

}
\references{
Rajaratnam JK, Tran LN, Lopez AD, Murray CJL (2010) Measuring Under-Five Mortality: Validation of New Low-Cost Methods. PLOS Medicine 7(4): e1000253.
(\doi{10.1371/journal.pmed.1000253}{10.1371/journal.pmed.1000253})
}
