% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{estimate_effect_size}
\alias{estimate_effect_size}
\title{Estimates size of the external effect}
\usage{
estimate_effect_size(df, date_effect_start, buffer = 0, verbose = FALSE)
}
\arguments{
\item{df}{Data.table or data.frame with the following columns
\describe{
\item{date}{Date of the observation. Needs to be comparable to
date_effect_start element.}
\item{value}{True observed value of the station}
\item{prediction}{Predicted model output for the same time and station
as value}
}}

\item{date_effect_start}{A date. Start date of the
effect that is to be evaluated. The data from this point onward is disregarded
for calculating model performance.}

\item{buffer}{Integer. An additional buffer window before date_effect_start to account
for uncertainty in the effect start point. Disregards additional buffer data
points for model evaluation}

\item{verbose}{Prints an explanation of the results if TRUE}
}
\value{
A list with two numbers: Absolute and relative estimated effect size.
}
\description{
Calculates an estimate for the absolute and relative effect size of the
external effect. The absolute effect is the difference between the model
bias in the reference time and the effect time windows. The relative effect
is the absolute effect divided by the mean true value in the reference
window.
}
\details{
Note: Since the bias is of the model is an average over predictions and true
values, it is important, that the effect window is specified correctly.
Imagine a scenario like a fire which strongly affects the outcome for one
hour and is gone the next hour. If we use a two week effect window, the
estimated effect will be 14*24=336 times smaller compared to using a 1-hour
effect window. Generally, we advise against studying very short effects (single
hour or single day). The variability of results will be too large to learn
anything meaningful.
}
