% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/ulid-package.R
\docType{package}
\name{generate}
\alias{ulid-package}
\alias{generate}
\alias{unmarshal}
\alias{ts_generate}
\alias{ulid}
\alias{ulid_generate}
\alias{ULIDgenerate}
\title{Generate ULID}
\usage{
generate(n = 1L)

unmarshal(ulids)

ts_generate(tsv)

ulid(n = 1L)

ulid_generate(n = 1L)

ULIDgenerate(n = 1L)
}
\arguments{
\item{n}{number of id's to generate (default = \code{1})}

\item{ulids}{character ULIDs (e.g. created with \code{generate()})}

\item{tsv}{vector of \code{POSIXct} values}
}
\value{
A \code{data.frame} with two columns \code{ts} and \code{rnd}.
}
\description{
\code{generate()} generates a new \href{https://github.com/ulid/spec}{Universally Unique Lexicographically Sortable Identifier}. Several aliases are
available for convience and backwards-compatibility.

This function generates a new \href{https://github.com/ulid/spec}{Universally Unique Lexicographically Sortable Identifier} from a vector of
\code{POSIXct} timestamps.

As described in the \href{https://github.com/ulid/spec}{ulid specification repo}, and slightly edited here,
UUID use can be suboptimal for many uses-cases because:(grifted from \url{https://github.com/ulid/spec})

UUID can be suboptimal for many uses-cases because:
\itemize{
\item It isn't the most character efficient way of encoding 128 bits of randomness
\item UUID v1/v2 is impractical in many environments, as it requires access to a unique, stable MAC address
\item UUID v3/v5 requires a unique seed and produces randomly distributed IDs, which can cause fragmentation in many data structures
\item UUID v4 provides no other information than randomness which can cause fragmentation in many data structures
}

Instead, an alternative is proposed in ULID:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ulid() // 01ARZ3NDEKTSV4RRFFQ69G5FAV
}\if{html}{\out{</div>}}

with the following properties:
\itemize{
\item 128-bit compatibility with UUID
\item 1.21e+24 unique ULIDs per millisecond
\item Lexicographically sortable!
\item Canonically encoded as a 26 character string, as opposed to the 36 character UUID
\item Uses Crockford's base32 for better efficiency and readability (5 bits per character)
\item Case insensitive
\item No special characters (URL safe)
\item Monotonic sort order (correctly detects and handles the same millisecond)
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{01AN4Z07BY      79KA1307SR9X4MV3

|----------|    |----------------|
  Timestamp          Randomness
   48bits              80bits
}\if{html}{\out{</div>}}

\strong{Components}

\emph{Timestamp}
\itemize{
\item 48 bit integer
\item UNIX-time in milliseconds
\item Will not run out of space until the year 10889 AD.
}

\emph{Randomness}
\itemize{
\item 80 bits
\item Cryptographically secure source of randomness, if possible
}

\strong{Sorting}

The left-most character must be sorted first, and the right-most character sorted last (lexical order).
The default ASCII character set must be used. Within the same millisecond, sort order is not guaranteed.
}
\details{
Note that up until release 0.3.1, the implementations had limitations
that resulted in second rather than millisecond resolution. This has
been addressed for release 0.4.0 and is now supported as expected.
}
\examples{
ULIDgenerate()
unmarshal(generate())
ts_generate(as.POSIXct("2017-11-01 15:00:00", origin="1970-01-01"))
}
\seealso{
The \href{https://github.com/ulid/spec}{ulid specification} provides the reference.
}
\author{
Bob Rudis (bob@rud.is) wrote the package based on \code{ulid} C++ library by Suyash Verma.

Dirk Eddelbuettel now maintains the package.
}
