% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM.split.R
\name{KM.split}
\alias{KM.split}
\title{Kaplan-Meier estimator of binary splitting}
\usage{
KM.split(t.vec, d.vec, X.mat, x.name, cutoff)
}
\arguments{
\item{t.vec}{:Vector of survival times (time to either death or censoring)}

\item{d.vec}{:Vector of censoring indicators (1=death, 0=censoring)}

\item{X.mat}{:n by p matrix of covariates, where n is the sample size and p is the number of covariates}

\item{x.name}{:the name of covariate}

\item{cutoff}{:cut-off-point}
}
\value{
P-value of two sample logrank test and a plot of two KM estimates
}
\description{
Given a cut-off-point and selected covariate, return the survival curve for binary classification and the P-value of two sample log-rank test.
}
\examples{
data(Lung,package="compound.Cox")
train_Lung=Lung[which(Lung[,"train"]==TRUE),] #select training data
t.vec=train_Lung[,1]
d.vec=train_Lung[,2]
x.mat=train_Lung[,-c(1,2,3)]
KM.split(t.vec,d.vec,x.mat,x.name="ANXA5",cutoff=1)
}
