% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uni.tree.R
\name{uni.tree}
\alias{uni.tree}
\title{A survival tree based on stabilized score tests}
\usage{
uni.tree(
  t.vec,
  d.vec,
  X.mat,
  P.value = 0.01,
  d0 = 0.01,
  S.plot = FALSE,
  score = TRUE
)
}
\arguments{
\item{t.vec}{:Vector of survival times (time to either death or censoring)}

\item{d.vec}{:Vector of censoring indicators (1=death, 0=censoring)}

\item{X.mat}{:n by p matrix of covariates (features), where n is the sample size and p is the number of covariates}

\item{P.value}{:the threshold of P-value for stop splitting (stopping criterion)}

\item{d0}{:A positive constant to stabilize the variance of score statistics (Witten & Tibshirani 2010)}

\item{S.plot}{:call for plot the KM estimator for each split}

\item{score}{:TRUE = score test (Emura et al. 2019); FALSE = log-rank test}
}
\value{
A nested list describing a classification tree, consisting of inner nodes and terminal node.
}
\description{
This function returns a classification (decision) tree for a given survival dataset. The decision of making inner nodes (splitting criterion) is 
based on the univariate score tests.
The decision of declaring terminal nodes (stopping criterion) is the P-value threshold given by an argument.
This tree construction algorithm is proposed by Emura et al. (2021).
}
\details{
In order to stabilize the univariate score tests, a small value "d0" is added to the variance of the score statistics (Witten and Tibshirani 2010).
d0=0 corresponds to the logrank test. To perform a large number of the score tests, the "compound.Cox" packages (Emura et al.2019) is applied with d0 as a option.
}
\examples{
data(Lung,package="compound.Cox")
train_Lung=Lung[which(Lung[,"train"]==TRUE),] #select training data
t.vec=train_Lung[,1]
d.vec=train_Lung[,2]
x.mat=train_Lung[,-c(1,2,3)]
uni.tree(t.vec,d.vec,x.mat,P.value=0.01,d0=0.01,S.plot=FALSE,score=TRUE)
}
\references{
Emura T, Hsu WC, Chou WC (2021). A survival tree based on stabilized score tests for high-dimensional covariates, in review

Emura T, Matsui S, Chen HY (2019). compound.Cox: Univariate Feature Selection and Compound Covariate for Predicting Survival, Computer Methods and Programs in Biomedicine 168: 21-37.

Witten DM, Tibshirani R (2010) Survival analysis with high-dimensional covariates. Stat Method Med Res 19:29-51
}
