% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\alias{partition_dim}
\title{Divide a grid of cells into partitions containing individual tables}
\usage{
partition(cells, corners, align = "top_left", nest = TRUE, strict = TRUE)

partition_dim(positions, cutpoints, bound = "upper")
}
\arguments{
\item{cells}{Data frame or tbl, the cells to be partitioned, from
\code{\link[=as_cells]{as_cells()}} or \code{\link[tidyxl:xlsx_cells]{tidyxl::xlsx_cells()}}.}

\item{corners}{usually a subset of \code{cells}, being the corners of individual
tables.  Can also be cells that aren't among \code{cells}, in which case see the
\code{strict} argument.}

\item{align}{Character, the position of the corner cells relative to their
tables, one of \code{"top_left"} (default), \code{"top_right"}, \code{"bottom_left"},
\code{"bottom_right"}.}

\item{nest}{Logical, whether to nest the partitions in a list-column of data
frames.}

\item{strict}{Logical, whether to omit partitions that don't contain a corner
cell.}

\item{positions}{Integer vector, the positions of cells (either the row
position or the column position), which are to be grouped between
cutpoints.}

\item{cutpoints}{Integer vector. The \code{positions} will be separated into
groups either side of each cutpoint.}

\item{bound}{One of \code{"upper"} or \code{"lower"}, controls whether cells that lie
on a cutpoint are should be grouped with cells below or above the cutpoint.
For example, if column 5 is a cutpoint, and a cell is in column 5,
\code{"lower"} would group it with cells in columns 1 to 4, whereas \code{"upper"}
would group it with cells in columns 6 to 10.  This is so that you can use
cells at the bottom or the right-hand side of a table as the cutpoints
(either of which would be 'upper' bounds because row and column numbers
count from 1 in the top-left row and column).  When \code{"upper"}, any
\code{cell_positions} above the first cutpoint will be in group 0; when
\code{"lower"}, any \code{cell_positions} below the final cutpoint will be 0.}
}
\value{
\code{partition_dim()} returns an integer vector, numbering the groups of
cells.  Group 0 represents the cells above the first cutpoint (when \code{bound = "upper"}), or below the first cutpoint (when \code{bound = "lower"}).  The
other groups are numbered from 1, where group 1 is adjacent to group 0.

\code{partition_dim()} returns an integer vector, numbering the groups of cells.
Group 0 represents the cells above the first cutpoint (when \code{bound = "upper"}), or below the first cutpoint (when \code{bound = "lower"}).  The other
groups are numbered from 1, where group 1 is adjacent to group 0.  Divide a
grid of cells into chunks along both dimensions
}
\description{
Given the positions of corner cells that mark individual tables in a single
spreadsheet, \code{partion()} works out which table cells belong to which corner
cells.  The individual tables can then be worked on independently.

\code{partition()} partitions along both dimensions (rows and columns) at once.
\code{partition_dim()} partitions along one dimension at a time.
}
\section{Functions}{
\itemize{
\item \code{partition_dim()}: Divide a grid of cells into chunks along one dimension

}}
\examples{
# The `purpose` dataset, represented in four summary tables
multiples <- purpose$small_multiples
rectify(multiples, character, numeric)

# The same thing in its raw 'melted' form that can be filtered
multiples

# First, find the cells that mark a corner of each table
corners <-
  dplyr::filter(multiples,
                !is.na(character),
                !(character \%in\% c("Sex", "Value", "Female", "Male")))

# Then find out which cells fall into which partition
partition(multiples, corners)

# You can also use bottom-left corners (or top-right or bottom-right)
bl_corners <- dplyr::filter(multiples, character == "Male")
partition(multiples, bl_corners, align = "bottom_left")

# To complete the grid even when not all corners are supplied, use `strict`
bl_corners <- bl_corners[-1, ]
partition(multiples, bl_corners, align = "bottom_left")
partition(multiples, bl_corners, align = "bottom_left", strict = FALSE)
# Given a set of cells in rows 1 to 10, partition them at the 3rd, 5th and 7th
# rows.
partition_dim(1:10, c(3, 5, 7))

# Given a set of cells in columns 1 to 10, partition them at the 3rd, 5th and
# 7th column.  This example is exactly the same as the previous one, to show
# that the function works the same way on columns as rows.
partition_dim(1:10, c(3, 5, 7))

# Given a set of cells in rows 1 to 10, partition them at the 3rd, 5th and
# 7th rows, aligned to the bottom of the group.
partition_dim(1:10, c(3, 5, 7), bound = "lower")

# Non-integer row/column numbers and cutpoints can be used, even though they
# make no sense in the context of partioning grids of cells.  They are
# rounded towards zero first.
partition_dim(1:10 - .5, c(3, 5, 7))
partition_dim(1:10, c(3, 5, 7) + 1.5)
}
