% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whitelies.R
\name{disguise}
\alias{disguise}
\title{Disguise the sample mean and sample deviation}
\usage{
disguise(usersample, method = 2)
}
\arguments{
\item{usersample}{A vector of all individual sample values.}

\item{method}{Approach for disguising mean and standard deviation. (default = 1)}
}
\value{
Outputs disguised mean and disguised standard deviation.
}
\description{
Disguises the sample mean and standard deviation via a choice of methods.
}
\details{
*Method 1*

Randomly split the sample into two (approx. equal size) samples A, and B.
For sample A calculate and report mean. For sample B calculate and
standard deviation.


*Method 2* (default)

Take a sample of size N with replacement; calculate and report mean.
Repeat to calculate and report standard deviation.


*Method 3*

Generate a random number (RN1) between N/2 and N. Sample with
replacement a sample size of RN1; calculate and report mean.
Generate a random number (RN2) between N/2 and N. Sample with
replacement a sample size of RN2; calculate and report standard deviation.


*Method 4*

As Method 3, but sampling without replacement.
}
\examples{

usersample<-c(1,1,2,3,4,4,5)

disguise(usersample,method=1)
disguise(usersample,method=2)
disguise(usersample,method=3)
disguise(usersample,method=4)


}
\references{
Derrick, B., Green, L., Kember, K., Ritchie, F. & White P, 2022, Safety in numbers: Minimum thresholding, Maximum bounds, and Little White Lies.
Scottish Economic Society Annual Conference, University of Glasgow, 25th-27th April 2022
}
