% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_fixed_variables.R
\name{simplify_fixed_variables}
\alias{simplify_fixed_variables}
\title{Simplify fixed variables}
\usage{
simplify_fixed_variables(x, eps = 1e-08, ...)
}
\arguments{
\item{x}{\code{\link[validate:validator]{validate::validator()}} object with validation rules}

\item{eps}{detected fixed values will have this precission.}

\item{...}{passed to \code{\link[=substitute_values]{substitute_values()}}.}
}
\value{
\code{\link[validate:validator]{validate::validator()}} object in which
}
\description{
Detect variables of which the values are restricted to a single value by the
rule set. Simplify the rule set by replacing fixed variables with these values.
}
\examples{
library(validate)
rules <- validator( x >= 0
                  , x <= 0
                  )
detect_fixed_variables(rules)
simplify_fixed_variables(rules)

rules <- validator( x1 + x2 + x3 == 0
                  , x1 + x2 >= 0
                  , x3 >= 0
                  )
simplify_fixed_variables(rules)
}
\seealso{
Other redundancy: 
\code{\link{detect_fixed_variables}()},
\code{\link{detect_redundancy}()},
\code{\link{is_implied_by}()},
\code{\link{remove_redundancy}()},
\code{\link{simplify_rules}()}
}
\concept{redundancy}
