% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strands.r
\name{flip_strands}
\alias{flip_strands}
\title{Flip strands in intervals.}
\usage{
flip_strands(x)
}
\arguments{
\item{x}{\link{ivl_df}}
}
\description{
Flips positive (\code{+}) stranded intervals to negative (\code{-}) strands,
and vice-versa. Facilitates comparisons among intervals on opposing strands.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end, ~strand,
  "chr1", 1,      100,  "+",
  "chr2", 1,      100,  "-"
)

flip_strands(x)

}
\seealso{
Other utilities: 
\code{\link{bed12_to_exons}()},
\code{\link{bed_makewindows}()},
\code{\link{bound_intervals}()},
\code{\link{interval_spacing}()}
}
\concept{utilities}
