% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_auth_ldap.R
\name{vault_client_auth_ldap}
\alias{vault_client_auth_ldap}
\title{Vault LDAP Authentication Configuration}
\description{
Vault LDAP Authentication Configuration

Vault LDAP Authentication Configuration
}
\details{
Interact with vault's LDAP authentication backend.  This backend
can be used to configure users based on their presence or group
membership in an LDAP server.  For more information, please see
the vault documentation
https://developer.hashicorp.com/vault/docs/auth/ldap
}
\examples{
server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  root <- server$client()

  # The ldap authentication backend is not enabled by default,
  # so we need to enable it first
  root$auth$enable("ldap")

  # Considerable configuration is required to make this work. Here
  # we use the public server available at
  # https://www.forumsys.com/2022/05/10/online-ldap-test-server/
  root$auth$ldap$configure(
    url = "ldap://ldap.forumsys.com",
    binddn = "cn=read-only-admin,dc=example,dc=com",
    bindpass = "password",
    userdn = "dc=example,dc=com",
    userattr = "uid",
    groupdn = "dc=example,dc=com",
    groupattr = "ou",
    groupfilter = "(uniqueMember={{.UserDN}})")

  # You can associate groups of users with policies:
  root$auth$ldap$write("scientists", "default")

  # Create a new client and login with this user:
  newton <- vaultr::vault_client(
    addr = server$addr,
    login = "ldap",
    username = "newton",
    password = "password")

  # (it is not recommended to login with the password like this as
  # it will end up in the command history, but in interactive use
  # you will be prompted securely for password)

  # Isaac Newton has now logged in and has only "default" policies
  newton$auth$token$lookup_self()$policies

  # (wheras our original root user has the "root" policy)
  root$auth$token$lookup_self()$policies
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_auth_ldap}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_client_auth_ldap-new}{\code{vault_client_auth_ldap$new()}}
\item \href{#method-vault_client_auth_ldap-custom_mount}{\code{vault_client_auth_ldap$custom_mount()}}
\item \href{#method-vault_client_auth_ldap-configure}{\code{vault_client_auth_ldap$configure()}}
\item \href{#method-vault_client_auth_ldap-configuration}{\code{vault_client_auth_ldap$configuration()}}
\item \href{#method-vault_client_auth_ldap-write}{\code{vault_client_auth_ldap$write()}}
\item \href{#method-vault_client_auth_ldap-read}{\code{vault_client_auth_ldap$read()}}
\item \href{#method-vault_client_auth_ldap-list}{\code{vault_client_auth_ldap$list()}}
\item \href{#method-vault_client_auth_ldap-delete}{\code{vault_client_auth_ldap$delete()}}
\item \href{#method-vault_client_auth_ldap-login}{\code{vault_client_auth_ldap$login()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_auth_ldap} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$new(api_client, mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}

\item{\code{mount}}{Mount point for the backend}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-custom_mount"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-custom_mount}{}}}
\subsection{Method \code{custom_mount()}}{
Set up a \code{vault_client_auth_ldap} object at a
custom mount. For example, suppose you mounted the \code{ldap}
authentication backend at \verb{/ldap-dev} you might use \code{ldap <- vault$auth$ldap2$custom_mount("/ldap-dev")} - this pattern
is repeated for other secret and authentication backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$custom_mount(mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mount}}{String, indicating the path that the engine is mounted at.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-configure"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-configure}{}}}
\subsection{Method \code{configure()}}{
Configures the connection parameters for
LDAP-based authentication. Note that there are many options
here and not all may be well supported. You are probably best
to configure your vault-LDAP interaction elsewhere, and this
method should be regarded as experimental and for testing
purposes only.

See the official docs
(https://developer.hashicorp.com/vault/api-docs/auth/ldap,
"Configure LDAP") for the list of accepted parameters here
via the dots argument; these are passed through directly
(with the exception of \code{url} which is the only required
parameter and for which concatenation of multiple values is
done for you.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$configure(url, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The LDAP server to connect to. Examples:
\verb{ldap://ldap.myorg.com},
\verb{ldaps://ldap.myorg.com:636}. Multiple URLs can be specified
with a character vector, e.g. \code{c("ldap://ldap.myorg.com", , "ldap://ldap2.myorg.com")}; these will be tried in-order.}

\item{\code{...}}{Additional arguments passed through with the body}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-configuration"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-configuration}{}}}
\subsection{Method \code{configuration()}}{
Reads the connection parameters for LDAP-based
authentication.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$configuration()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-write"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-write}{}}}
\subsection{Method \code{write()}}{
Create or update a policy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$write(name, policies, user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the group (or user)}

\item{\code{policies}}{A character vector of vault policies that this
group (or user) will have for vault access.}

\item{\code{user}}{Scalar logical - if \code{TRUE}, then \code{name} is
interpreted as a \emph{user} instead of a group.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-read}{}}}
\subsection{Method \code{read()}}{
Write a mapping between a LDAP group or user and
a set of vault policies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$read(name, user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the group (or user)}

\item{\code{user}}{Scalar logical - if \code{TRUE}, then \code{name} is
interpreted as a \emph{user} instead of a group.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-list"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-list}{}}}
\subsection{Method \code{list()}}{
List groups or users known to vault via LDAP
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$list(user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{Scalar logical - if \code{TRUE}, then list users
instead of groups.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-delete"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a group or user (just the mapping to vault,
no data on the LDAP server is modified).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$delete(name, user = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the group (or user)}

\item{\code{user}}{Scalar logical - if \code{TRUE}, then \code{name} is
interpreted as a \emph{user} instead of a group.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_auth_ldap-login"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_auth_ldap-login}{}}}
\subsection{Method \code{login()}}{
Log into the vault using LDAP authentication.
Normally you would not call this directly but instead use
\verb{$login} with \code{method = "ldap"} and proving the \code{username}
and optionally the \code{password} argument.
argument.  This function returns a vault token but does not
set it as the client token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_auth_ldap$login(username, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{Username to authenticate with}

\item{\code{password}}{Password to authenticate with. If omitted or
\code{NULL} and the session is interactive, the password will be
prompted for.}
}
\if{html}{\out{</div>}}
}
}
}
