% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.propratio2}
\alias{replicate.propratio2}
\title{Compares and combines 2-group proportion ratios in original and follow-up
studies}
\usage{
replicate.propratio2(alpha, f11, f12, n11, n12, f21, f22, n21, n22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{frequency count for group 1 in original study}

\item{f12}{frequency count for group 2 in original study}

\item{n11}{sample size for group 1 in original study}

\item{n12}{sample size for group 2 in original study}

\item{f21}{frequency count for group 1 in follow-up study}

\item{f22}{frequency count for group 2 in follow-up study}

\item{n21}{sample size for group 1 in follow-up study}

\item{n22}{sample size for group 2 in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the ratio of proportion ratios
\item Row 4 estimates the geometric average proportion ratio
}

The columns are:
\itemize{
\item Estimate - proportion ratio estimate (single study, ratio, average)
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals from an original study and a
follow-up study where the effect size is a 2-group proportion ratio.
Confidence intervals for the ratio and geometric average of effect sizes
are also computed. The confidence level for the ratio of ratios is 1 – 2*alpha,
which is recommended for equivalence testing.
}
\examples{
replicate.propratio2(.05, 21, 16, 40, 40, 19, 13, 60, 60)

# Should return:
#                      Estimate        LL       UL
# Original:           1.3076923 0.8068705 2.119373
# Follow-up:          1.4528302 0.7939881 2.658372
# Original/Follow-up: 0.9000999 0.4703209 1.722611
# Average:            1.3783522 0.9362893 2.029132


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
