#' Tropheus IK coord dataset
#'
#' A data frame of 511 observations of 58 variables.
#' This is a subset of the Tropheus data frame constituted by cichlid fishes
#' of the species \emph{Tropheus moorii} (color morph 'Kaiser')
#' collected from six locations of Lake Tanganyika (Kerschbaumer et al., 2013, 2014).
#' The coordinates result from the generalised Procrustes analysis, for this subset,
#' of the 2D Cartesian coordinates of 19 landmarks quantifying the external body morphology of adult fishes.
#'
#' \itemize{
#' \item \strong{List_TropheusData_ID} {Specimen ID}
#' \item \strong{Extractionnr.} {Extraction number for genomic DNA}
#' \item \strong{G} {Group number}
#' \item \strong{POP.ID} {Population Id}
#' \item \strong{Sex} {Sex}
#' \item \strong{Allo.Symp} {Allopatric or sympatric population}
#' \item \strong{X1 ... Y19} {Procrustes coordinates of 19 landmarks}
#' \item \strong{Pzep3_1 ... UME003_2} {Genotype for 6 microsatellite markers}
#' }
#'
#' @seealso \code{\link{Tropheus}}
#'
#' @references Kerschbaumer M, Mitteroecker P, Sturmbauer C (2014)
#' Evolution of body shape in sympatric versus non-sympatric Tropheus populations of Lake Tanganyika. \emph{Heredity 112(2)}: 89–98. \url{https://doi.org/10.1038/hdy.2013.78}
#' @references Kerschbaumer M, Mitteroecker P, Sturmbauer C (2013)
#' Data from: Evolution of body shape in sympatric versus non-sympatric Tropheus populations of Lake Tanganyika. \emph{Dryad Digital Repository}. \url{https://doi.org/10.5061/dryad.fc02f}
#'
#' @name Tropheus.IK.coord
#' @usage data(Tropheus.IK.coord)
#' @format A data frame with 511 rows and 58 variables
#' @docType data
NULL
