% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minv.R
\name{minv}
\alias{minv}
\title{Matrix pseudoinverse}
\usage{
minv(M, method = 0, pa = 0)
}
\arguments{
\item{M}{a numeric matrix (square matrix)}

\item{method}{an integer for the method of inversion.
If method = 0, only the nonzero eigenvalues are kept;
if method = 1, only the eigenvalues above a threshold are kept;
if method = 2, only the several first eigenvalues are kept;
if method = 3, a Tikhonov regularization (= ridge regression) is performed.}

\item{pa}{an integer for the parameter of inversion.
If method = 1, pa is the threshold below which the eigenvalues are not kept;
if method = 2, pa is an positive integer number corresponding to number of eigenvalues that are kept;
if method = 3, pa is the scaling factor for the identity matrix}
}
\value{
A numeric matrix corresponding to the pseudoinverse of M
}
\description{
Computes the inverse or the pseudoinverse of a matrix
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus.IK.coord")
coords <- which(names(Tropheus.IK.coord) == "X1"):which(names(Tropheus.IK.coord) == "Y19")
proc.coord <- as.matrix(Tropheus.IK.coord[coords])

# Covariance matrix of each population
S.phen.pop <- cov.group(proc.coord, groups = Tropheus.IK.coord$POP.ID)

# Pseudo-inversion of a square matrix (covariance matrix of the population IKS5)
S2 <- S.phen.pop[, , "IKS5"]
invS2 <- minv(S2, method = 0, pa = 0)  # Pseudoinverse keeping non-zero eigenvalues
invS2 <- minv(S2, method = 1, pa = 10^-8)  # Pseudoinverse keeping eigenvalues above 10^-8
invS2 <- minv(S2, method = 2, pa = 5)  # Pseudoinverse keeping the first five eigenvalues
invS2 <- minv(S2, method = 3, pa = 0.5)  # Ridge regression with Tikhonov factor of 0.5

}
