% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.r
\encoding{UTF-8}
\name{encode_y}
\alias{encode_y}
\title{Encode y "channel"}
\usage{
encode_y(vl, field, type = "auto", aggregate = NULL, sort = NULL)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{field}{single element character vector naming the column}

\item{type}{the encoded field’s type of measurement. This can be either a full type
name (\code{quantitative}, \code{temporal}, \code{ordinal}, and \code{nominal})
or an initial character of the type name (\code{Q}, \code{T}, \code{O}, \code{N}).
This property is case insensitive. If \code{auto} is used, the type will
be guessed (so you may want to actually specify it if you want consistency).}

\item{aggregate}{perform aggregaton on \code{field}. See
\href{http://vega.github.io/vega-lite/docs/aggregate.html}{Supported Aggregation Options} for
more info on valid operations. Leave \code{NULL} for no aggregation.}

\item{sort}{either one of \code{ascending}, \code{descending} or (for ordinal scales)
the result of a call to \code{\link{sort_def}}}
}
\description{
Vega-Lite has many "encoding channels". Each channel definition object must
describe the data field encoded by the channel and its data type, or a constant
value directly mapped to the mark properties. In addition, it can describe the
mapped field’s transformation and properties for its scale and guide.
}
\note{
right now, \code{type} == "\code{auto}" just assume "\code{quantitative}". It
      will eventually get smarter, but you are better off specifying it.
}
\examples{
dat <- jsonlite::fromJSON('[
    {"a": "A","b": 28}, {"a": "B","b": 55}, {"a": "C","b": 43},
    {"a": "D","b": 91}, {"a": "E","b": 81}, {"a": "F","b": 53},
    {"a": "G","b": 19}, {"a": "H","b": 87}, {"a": "I","b": 52}
  ]')

vegalite() \%>\%
  add_data(dat) \%>\%
  encode_x("a", "ordinal") \%>\%
  encode_y("b", "quantitative") \%>\%
  mark_bar()
}

