% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.r
\encoding{UTF-8}
\name{mark_line}
\alias{mark_line}
\title{Line mark}
\usage{
mark_line(vl, orient = NULL, interpolate = NULL, tension = NULL,
  opacity = NULL, color = NULL, fill = NULL, stroke = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{orient}{the orientation of a non-stacked bar, area, and line charts.
The value is either "horizontal", or "vertical" (default). For bar and
tick, this determines whether the size of the bar and tick should be
applied to x or y dimension. For area, this property determines the
orient property of the Vega output. For line, this property determines
the path order of the points in the line if path channel is not specified.
For stacked charts, this is always determined by the orientation of the stack;
therefore explicitly specified value will be ignored.}

\item{interpolate}{The line interpolation method to use. One of \code{linear}
\code{step-before}, \code{step-after}, \code{basis}, \code{basis-open},
\code{basis-closed}, \code{bundle}, \code{cardinal}, \code{cardinal-open},
\code{cardinal-closed}, \code{monotone}. For more information about each
interpolation method, please see D3’s line interpolation.}

\item{tension}{Depending on the interpolation type, sets the tension parameter.
(See D3’s line interpolation.)}

\item{opacity}{\code{0.0}-\code{1.0}}

\item{color}{color of the mark – either fill or stroke color based on the filled mark config.}

\item{fill}{fill color. This config will be overridden by color channel’s
specified or mapped values if filled is true.}

\item{stroke}{stroke color. This config will be overridden by color channel’s
specified or mapped values if filled is false.}
}
\description{
A line mark represents the data points stored in a field with a line
connecting all of these points. Unlike other marks except area that represents
one data element per mark, one line mark represent multiple data element as
a single line.
}
\examples{
vegalite() \%>\%
  cell_size(300, 300) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/driving.json") \%>\%
  encode_x("miles", "quantitative") \%>\%
  encode_y("gas", "quantitative") \%>\%
  encode_path("year", "temporal") \%>\%
  scale_x_linear(zero=FALSE) \%>\%
  scale_y_linear(zero=FALSE) \%>\%
  mark_line()
}
\references{
\href{http://vega.github.io/vega-lite/docs/mark.html}{Vega-Lite Mark spec}
}

