% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-legends.R
\name{numericLegend}
\alias{numericLegend}
\title{Create a numeric legend}
\usage{
numericLegend(
  inputId,
  label = NULL,
  class = "",
  n = 100,
  minValue = NULL,
  maxValue = NULL,
  data = NULL,
  colors = NULL,
  palette = NULL,
  options = NULL,
  orient = "bottom",
  size = 200,
  thickness = 20,
  offset = 0
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{class}{The CSS class of the input div element to match with any brush-defining functions. Default classes for brushes are either \code{"continuous-color-filter"} or \code{"discrete-color-filter"}.}

\item{n}{Number of color strips in the legend. Default is \code{100}.}

\item{minValue}{Minimum numeric value in the legend (can be higher the maximum for inverted scale).}

\item{maxValue}{Maximum numeric value in the legend (can be lower the minimum for inverted scale).}

\item{data}{Alternative vector to extract numeric minimum and maximum values.}

\item{colors}{Colours to interpolate; must be a valid argument to
\code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}. This can be a character vector of
\code{"#RRGGBB"} or  \code{"#RRGGBBAA"}, colour names from
\code{\link[grDevices:colors]{grDevices::colors()}}, or a positive integer that indexes into
\code{\link[grDevices:palette]{grDevices::palette()}}.}

\item{palette}{A function that outputs a list of colors}

\item{options}{Configuration options for brush and scale. Use \code{ticks} to specify number of ticks or a list of specific tick values
, \code{format} to a d3-format-compatible formatting string (see \url{https://github.com/d3/d3-format} for valid formats) and
\code{hide_brush_labels} as \code{TRUE} to hide the brush interval.}

\item{orient}{Orientation of the legend. Can be \code{"bottom"} (default, horizontal with labels below), \code{"top"} (horizontal with labels above), \code{"left"} (vertical with labels on the left)
and \code{"right"} (vertical with labels on the right).}

\item{size}{Absolute length in pixels of the color bar; becomes width or height depending on value of \code{orient}. Default is \code{200}.}

\item{thickness}{Absolute thickness in pixels of the color bar; opposite of size depending on value of \code{orient}. Default is \code{20}.}

\item{offset}{Left offset for scale to allow long labels. Default is \code{0}.}
}
\value{
A numeric color legend control that can be added to a UI definition
}
\description{
Create a color legend based on given data and palette or colors. Also passes on data- attributes for optional JS interaction.
}
\seealso{
\code{\link[=discreteColorFilter]{discreteColorFilter()}} \code{\link[=continuousColorFilter]{continuousColorFilter()}} \code{\link[=categoricalColorFilter]{categoricalColorFilter()}}

Other base legend: 
\code{\link{categoricalLegend}()}
}
\concept{base legend}
