% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_vin.R
\name{decode_vin}
\alias{decode_vin}
\title{Use the NHTSA API to Decode VINs}
\usage{
decode_vin(vin, ...)
}
\arguments{
\item{vin}{either a single vehicle identification number in a character
string, or multiple vehicle identification numbers in a character vector.}

\item{...}{additional arguments passed to the url builder functions.}
}
\value{
a data frame with the VIN, Make, Model, Model Year, Fuel Type, and
Gross Vehicle Weight Rating (GVWR) for the specified VINs.
}
\description{
Use the NHTSA API to Decode VINs
}
\examples{
\dontrun{
# Decode a single VIN:
decode_vin("JHLRD68404C018253")

# Decode multiple VINs:
decode_vin(c("JHLRD68404C018253", "JH4DA9450MS001229"))
}
}
