% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_vint.R
\name{vivi_importance}
\alias{vivi_importance}
\title{vivi_importance}
\usage{
vivi_importance(
  data,
  fit,
  response,
  importanceType = "agnostic",
  class = 1,
  predictFun = NULL,
  numPerm = 4,
  showVimpError = FALSE,
  vars = NULL,
  as_matrix = FALSE,
  reorder = FALSE
)
}
\arguments{
\item{data}{Data frame used for \code{fit}.}

\item{fit}{A supervised ML model understood by \code{condvis2::CVpredict} (or supply \code{predictFun}).}

\item{response}{Name of the response column in \code{data}.}

\item{importanceType}{Importance metric to use. Defaults to "agnostic"
(permutation via flashlight). If an embedded metric exists, set this to that
metric name to extract it instead.}

\item{class}{Classification level (factor level or 1-based index) when \code{response} is a factor.}

\item{predictFun}{Optional prediction function of signature \verb{(fit, data, prob = TRUE/FALSE)}.
If \code{NULL}, an internal CVpredict-based function is used.}

\item{numPerm}{Number of permutations for agnostic importance. Default 4.}

\item{showVimpError}{If TRUE and \code{numPerm > 1}, print standard errors.}

\item{vars}{Optional character vector of feature names to restrict the calculation.}

\item{as_matrix}{If TRUE, return a square matrix with importances on the diagonal
and zeros elsewhere; otherwise return a named numeric vector. Default FALSE.}

\item{reorder}{If \code{as_matrix = TRUE}, optionally reorder the matrix with \code{vividReorder()}. Default FALSE.}
}
\value{
Named numeric vector of importances, or a square matrix if \code{as_matrix = TRUE}.
}
\description{
Compute variable importance only, without interactions.
}
\examples{
# Example 1 — importance as a named vector
aq <- na.omit(airquality)
fit_lm <- lm(Ozone ~ ., data = aq)
imp_vec <- vivi_importance(data = aq, fit = fit_lm, response = "Ozone")
head(imp_vec)

# Example 2 — importance as a diagonal matrix for plotting
imp_mat <- vivi_importance(data = aq, fit = fit_lm, response = "Ozone",
                           as_matrix = TRUE)
# viviHeatmap(imp_mat)  # if you want to visualise the diagonal

# Example 3 — embedded importance from a random forest (if available)
\donttest{
if (requireNamespace("randomForest", quietly = TRUE)) {
  library(randomForest)
  rf <- randomForest(Ozone ~ ., data = aq, importance = TRUE)
  vivi_importance(data = aq, fit = rf, response = "Ozone",
                  importanceType = "\%IncMSE")
}
}

# Example 4 — classification model with ranger using embedded impurity importance
\donttest{
if (requireNamespace("ranger", quietly = TRUE)) {
  library(ranger)
  fit_rf <- ranger(Species ~ ., data = iris,
                   importance = "impurity", probability = TRUE)
  vivi_importance(data = iris, fit = fit_rf, response = "Species",
                  importanceType = "impurity")
}
}

}
