% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_longBoxPnL.R
\name{longBoxPnL}
\alias{longBoxPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Box Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
longBoxPnL(
  ST,
  X1H,
  X2,
  P1,
  C2,
  P3,
  C4,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1H}{Higher Strike Price or eXercise price for one ITM long Put and one OTM shorted call .}

\item{X2}{Strike Price or eXercise price for one shorted Put and one long call.}

\item{P1}{Put Premium or Put Price received for the shorted Put.}

\item{C2}{Put Premium or Put Price paid for the bought Call.}

\item{P3}{Put Premium or Put Price paid for the bought Put.}

\item{C4}{Call Premium or Put Price received for the shorted Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
The Long Box is a complex strategy that can (in some jurisdictions) have beneficial effects for tax planning from year to year. If your incentive for this strategy is a tax play, you should consult with your tax advisor beforehand to evaluate whether or not it is valid where you live and trade to invest (Cohen, 2015).\cr
This volatility strategy can be viewed as a combination of a bull call spread and a bear put spread, and consists of a long position in an ITM put option with a strike price X1H, a short position in an OTM put option with a lower strike price X2, a long position in an ITM call option with the strike price X2, and a short position in an OTM call option with the strike price X1H. The trader or investor has an outlook that is  neutral (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long Box Option Strategy and draw its graph in the Plots tab.
}
\examples{
longBoxPnL(34,40,30,1,6,7,2)
}
