% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_stripPnL.R
\name{stripPnL}
\alias{stripPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Strip Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
stripPnL(
  ST,
  X,
  C,
  P1,
  P2,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium or Call Price paid for bought Call.}

\item{P1}{Put Premium paid for the first bought put.}

\item{P2}{Put Premium paid for the second bought put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This Strategy consists of a long call position (in an at the money call option) and a long position in two put options (at the money) with a strike price X. The Strip is a simple adjustment to the Straddle to make it more biased toward the downside. In buying a second put, the strategy retains its preference for high volatility but now with a more bearish slant (Cohen, 2016).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Strip Option Strategy and draw its graph in the Plots tab. EXAMPLE, Buy HypoVola December 9 call at $1.40 (outflow) and Buy two HypoVola December 9 Puts at $0.80 (outflow). This is a net debit trade and involves three cash outflows. The Bar Plot gets displayed in Plots tab.
}
\examples{
stripPnL(9,9,1.4,0.80,0.80)
stripPnL(40,40,2.00,1.25,1.25,hl=0.85,hu=1.25)
stripPnL(1000,1000,8,5.50,6.50,hl=0.985,hu=1.035)
}
