% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\alias{forest_plotly}
\alias{forest_ggplot}
\title{Forest plot individual gene from 2x3 factor analysis}
\usage{
forest_plot(
  object,
  genes,
  scheme = c("red", "green3", "blue"),
  labs = NULL,
  error_type = c("ci", "se"),
  error_width = 0.05,
  gap = 1,
  transpose = FALSE,
  mar = if (transpose) c(5, 7, 5, 4) else c(5, 5, 5, 3),
  ...
)

forest_plotly(
  object,
  genes,
  scheme = c("red", "green3", "blue"),
  labs = NULL,
  error_type = c("ci", "se"),
  error_width = 4,
  gap = 1,
  transpose = FALSE,
  ...
)

forest_ggplot(
  object,
  genes,
  scheme = c("red", "green3", "blue"),
  labs = NULL,
  error_type = c("ci", "se"),
  error_width = 0.3,
  facet = TRUE,
  gap = 1,
  transpose = FALSE,
  ...
)
}
\arguments{
\item{object}{A 'volc3d' class object from a 2x3 analysis generated by
\code{\link[=deseq_2x3_polar]{deseq_2x3_polar()}}}

\item{genes}{Vector of genes to plot}

\item{scheme}{Vector of 3 colours for plotting}

\item{labs}{Optional character vector of labels for the groups}

\item{error_type}{Either "ci" or "se" to specify whether error bars use 95\%
confidence intervals or standard error}

\item{error_width}{Width of error bars}

\item{gap}{Size of gap between groupings for each gene}

\item{transpose}{Logical whether to transpose the plot}

\item{mar}{Vector of margins on four sides. See \code{\link[=par]{par()}}}

\item{...}{Optional arguments}

\item{facet}{Logical whether to use facets for individual genes (ggplot2
only)}
}
\value{
Returns a plot using either base graphics (\code{forest_plot}), plotly
(\code{forest_plotly}) or ggplot2 (\code{forest_ggplot}). \code{forest_plot} also
invisibly returns the dataframe used for plotting.
}
\description{
Forest plot individual gene from 2x3 factor analysis using either base
graphics, plotly or ggplot2.
}
\seealso{
\code{\link[=deseq_2x3_polar]{deseq_2x3_polar()}}
}
