% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{vsts_auth_key}
\alias{vsts_auth_key}
\title{Azure DevOps Authentication Key}
\usage{
vsts_auth_key(user, pass)
}
\arguments{
\item{user}{username to access Azure DevOps project}

\item{pass}{password to access Azure DevOps project}
}
\value{
An authentication key string in the form of 'Basic <Base 64 of \code{user}:\code{pass}>'
}
\description{
Creation of a Azure DevOps authentication key that will be used when running any of the API calls.
}
\details{
For more information about authentication check
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops/?view=azure-devops-rest-6.1#create-the-request}
}
\examples{
# Using credentials
auth_key <- vsts_auth_key("<username>", "<password>")

# Using PAT token
auth_key <- vsts_auth_key(NULL, "<token>")

}
