% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{vsts_get_build_defs}
\alias{vsts_get_build_defs}
\title{Azure DevOps Project Build Definition Information}
\usage{
vsts_get_build_defs(domain, project, auth_key, query = NULL)
}
\arguments{
\item{domain}{The name of the Azure DevOps organization.}

\item{project}{the name of the project in \code{domain} to look at}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{query}{a list of extra parameters that can be sent to the API call. Check details for access to list
of options.}
}
\description{
These functions will allow you to scrape build definition information from Azure DevOps.
}
\details{
For more information about the build definition API calls check
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops/build/definitions/list}.
}
\examples{
\dontrun{
# Add in own details to get a non-NULL output
auth_key <- vsts_auth_key("<username>", "<password>")
vsts_get_build_defs("domain", "project", auth_key)
}

}
