% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Hoover}
\alias{Hoover}
\title{Hoover index}
\usage{
Hoover(X, W = rep(1, length(X)))
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}
}
\value{
The value of Hoover coefficient.
}
\description{
Computes Hoover inequality measure of a given variable taking into account weights.
}
\details{
Let \eqn{x_{i}} be the income of the i-th person and \eqn{\overline{x}} be the mean income. Then the Hoover index H is:
\deqn{H={\frac {1}{2}}{\frac {\sum_{i}|x_{i}-{\overline{x}}|}{\sum_{i}x_{i}}}}
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
Hoover(X)
Hoover(X,W)

data(Tourism)
#Hoover index for Total expenditure with sample weights
X=Tourism$Total_expenditure
W=Tourism$Sample_weight
Hoover(X,W)


}
\references{
Hoover E. M. Jr.: (1936) The Measurement of Industrial Localization, The Review of Economics and Statistics, 18

Hoover E. M. Jr.: (1984) An Introduction to Regional Economics, ISBN 0-07-554440-7
}
