% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{webdav_download_file}
\alias{webdav_download_file}
\title{Download a file from the WebDAV server}
\usage{
webdav_download_file(
  base_url,
  file_path,
  destination_path = ".",
  username = Sys.getenv("WEBDAV_USERNAME"),
  password = Sys.getenv("WEBDAV_PASSWORD"),
  verbose = FALSE
)
}
\arguments{
\item{base_url}{The base URL of the WebDAV server (e.g., "https://example.com/remote.php/dav/files/").}

\item{file_path}{The path of the file on the WebDAV server to download (relative to the `base_url`).}

\item{destination_path}{The local directory where the downloaded file will be saved. Defaults to the current directory.}

\item{username}{The username for WebDAV authentication. Defaults to the "WEBDAV_USERNAME" environment variable.}

\item{password}{The password for WebDAV authentication. Defaults to the "WEBDAV_PASSWORD" environment variable.}

\item{verbose}{Logical. If TRUE, prints detailed messages during the download process.}
}
\value{
Logical value indicating whether the file was downloaded successfully.
}
\description{
This function downloads a file from the WebDAV server and saves it to a local directory.
It validates the provided parameters, handles errors, and optionally prints detailed logs if requested.
}
\examples{
# Example usage with a public WebDAV server.
library(httr2)
test_server <- "http://webdavserver.net/" |>
  request() |>
  req_retry(max_tries = 1, max_seconds = 2, backoff =  ~ 1) |>
  req_perform() |>
  try(silent = TRUE)

# Download a file from the WebDAV server
if (class(test_server) != "try-error")
  webdav_download_file(base_url = test_server$url,
    file_path = "Project.pdf",
    destination_path = tempdir(),
    verbose = TRUE)
# Visit test_server$url to view the results of the operation.
}
