% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.R
\name{funnel}
\alias{funnel}
\title{Create a Funnel Plot}
\usage{
funnel(effect, v, type = "se", flip = FALSE)
}
\arguments{
\item{effect}{a vector of meta-analytic effect sizes}

\item{v}{a vector of sampling variances}

\item{type}{\code{v} for variance or \code{se} for standard error; defaults to standard error}

\item{flip}{\code{FALSE} (default) for a horizontal plot; \code{TRUE} for a vertical plot}
}
\description{
This function allows you to create a funnel plot using a vector of effect sizes and a vector of their corresponding sampling variances.
}
\details{
This funnel plot, by default, plots the effect sizes on the y-axis and the measure of study size (either variance or standard error) on the x-axis. If no asymmetry is present, the plot should resemble a horizontal funnel.

Users can choose either standard error (default) or sampling variance as a measure of study size. The choice is mostly arbitrary. In both cases, however, \code{v} must be a vector of variances, the same as that required by \code{weightfunct}. The conversion to standard error is automatic.
}
\examples{
\dontrun{
# Funnel plot using standard error (default):
funnel(effect, v)
# Funnel plot using sampling variance:
funnel(effect, v, type='v')
}
}
\keyword{weightr}
