% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinetics.R
\name{perform_kinetics}
\alias{perform_kinetics}
\title{Perform VO2 kinetics fitting}
\usage{
perform_kinetics(
  .data_processed,
  intensity_domain = c("moderate", "heavy", "severe"),
  fit_level = 0.95,
  fit_phase_1_length,
  fit_baseline_length,
  fit_transition_length,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{.data_processed}{The data retrieved from \code{process_data()}.}

\item{intensity_domain}{The exercise-intensity domain that the test was performed. Either \emph{moderate}, \emph{heavy}, or \emph{severe}.}

\item{fit_level}{A numeric scalar between 0 and 1 giving the confidence level for the parameter estimates in the final VO2 kinetics fit. Default to \code{0.95}.}

\item{fit_phase_1_length}{The length of the phase I that you wish to exclude from the final exponential fit, in seconds. See  \verb{VO2 kinetics} section in \code{?vo2_kinetics} for more details.}

\item{fit_baseline_length}{The length the baseline to perform the final linear fit, in seconds. See \verb{VO2 kinetics} section \code{?vo2_kinetics} for more details.}

\item{fit_transition_length}{The length of the transition to perform the final exponential fit, in seconds. See \verb{VO2 kinetics} section \code{?vo2_kinetics} for more details.}

\item{verbose}{A boolean indicating whether messages should be printed in the console. Default to \code{TRUE}.}

\item{...}{Additional arguments when fitting VO2 kinetics in the heavy- or severe-intensity domains. Arguments may be the following:
\describe{
\item{\code{TODO}}{}
}}
}
\value{
a \code{\link[tibble:tibble-package]{tibble}} containing one row and the nested columns:
\item{data_fitted}{The data containing the time and VO2 columns, as well as the fitted data and its residuals for each data point.}
\item{model}{A \code{nls} object. The model used in the VO2 kinetics fitting.}
\item{model_summary}{The tidied summary of the \code{model}.}
\item{model_residuals}{The residuals of the \code{model}.}
\item{plot_model}{The final plot of the fitted \code{model}.}
\item{plot_residuals}{The residuals plot for the \code{model} diagnostics.}
}
\description{
Performs the fitting process for the VO2 kinetics analysis. At this point, the data should already have been cleaned (outliers removed) and processed
(interpolated, time-aligned, ensembled-averaged, and bin-averaged).
}
\details{
See \code{?vo2_kinetics} for details.
}
