% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_round.R
\name{end_round}
\alias{end_round}
\title{Manage list of possible hideouts}
\usage{
end_round(paths, hideouts = NULL)
}
\arguments{
\item{paths}{list of all possible paths already traveled}

\item{hideouts}{optional vector of possible hideouts from previous rounds. Not used in round 1, only rounds 2 and 3}
}
\value{
list of all possible hideouts
}
\description{
Create or update a list of possible hideouts based on final positions from the list of possible paths traveled.
}
\examples{
possibilities = start_round(64)
possibilities = take_a_step(possibilities,roads)
possibilities = take_a_step(possibilities,roads,blocked=list(c(63,82),c(63,65)))
possibilities = inspect_space(possibilities,space = c(29,30), clue = FALSE)
possibilities = inspect_space(possibilities,space = 49, clue = TRUE)
hideouts = end_round(possibilities,hideouts=NULL)
possibilities = start_round(67)
possibilities = take_a_step(possibilities,roads)
hideouts = end_round(possibilities,hideouts=hideouts)
}
