% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_rds_in_workspace}
\alias{read_rds_in_workspace}
\title{Read an R Object from a Workspace.}
\usage{
read_rds_in_workspace(x, name, subdir = NULL)
}
\arguments{
\item{x}{the workspace}

\item{name}{name of the object stored in the workspace}

\item{subdir}{Optional subdirectory used for the asset to retrieve}
}
\value{
the R object that was stored as an Rds file.
}
\description{
Read an R Object from a dataset stored as a RDS file
in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)
read_rds_in_workspace(z, name = "obj")
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_dataset_in_workspace}()},
\code{\link{read_json_str_in_workspace}()},
\code{\link{read_raster_in_workspace}()},
\code{\link{read_timestamp}()},
\code{\link{read_yaml_in_workspace}()}
}
\concept{functions to read in a workspace}
